"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utility_bar = require("./utility_bar");
var _links = require("../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Div = _styledComponents.default.div`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const CasesTable = ({
  columns,
  data,
  goToCreateCase,
  isCasesLoading,
  isCommentUpdating,
  isDataEmpty,
  isSelectorView,
  onChange,
  pagination,
  selectedCases,
  selection,
  sorting,
  tableRef,
  tableRowProps,
  deselectCases
}) => {
  var _data$total;
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getCreateCaseUrl,
    navigateToCreateCase
  } = (0, _navigation.useCreateCaseNavigation)();
  const navigateToCreateCaseClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    if (goToCreateCase != null) {
      goToCreateCase();
    } else {
      navigateToCreateCase();
    }
  }, [goToCreateCase, navigateToCreateCase]);
  return isCasesLoading && isDataEmpty ? /*#__PURE__*/_react.default.createElement(Div, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    "data-test-subj": "initialLoadingPanelAllCases",
    lines: 10
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.CasesTableUtilityBar, {
    isSelectorView: isSelectorView,
    totalCases: (_data$total = data.total) !== null && _data$total !== void 0 ? _data$total : 0,
    selectedCases: selectedCases,
    deselectCases: deselectCases
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: (0, _classnames.default)({
      isSelectorView
    }),
    columns: columns,
    "data-test-subj": "cases-table",
    isSelectable: !isSelectorView,
    itemId: "id",
    items: data.cases,
    loading: isCommentUpdating,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_CASES),
      titleSize: "xs",
      body: permissions.create ? i18n.NO_CASES_BODY : i18n.NO_CASES_BODY_READ_ONLY,
      actions: permissions.create && /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
        isDisabled: !permissions.create,
        fill: true,
        size: "s",
        onClick: navigateToCreateCaseClick,
        href: getCreateCaseUrl(),
        iconType: "plusInCircle",
        "data-test-subj": "cases-table-add-case"
      }, i18n.CREATE_CASE_TITLE)
    }),
    onChange: onChange,
    pagination: pagination,
    ref: tableRef,
    rowProps: tableRowProps,
    selection: !isSelectorView ? selection : undefined,
    sorting: sorting,
    hasActions: false
  }));
};
exports.CasesTable = CasesTable;
CasesTable.displayName = 'CasesTable';