"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityFilter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _types = require("../../containers/types");
var _config = require("../severity/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeverityFilter = ({
  selectedSeverity,
  onSeverityChange,
  isLoading,
  isDisabled
}) => {
  const caseSeverities = Object.keys(_config.severitiesWithAll);
  const options = caseSeverities.map(severity => {
    const severityData = _config.severitiesWithAll[severity];
    return {
      value: severity,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: 'center',
        responsive: false,
        "data-test-subj": `case-severity-filter-${severity}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, severity === _types.SeverityAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, severityData.label) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: severityData.color
      }, severityData.label)))
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: isDisabled,
    fullWidth: true,
    isLoading: isLoading,
    options: options,
    valueOfSelected: selectedSeverity,
    onChange: onSeverityChange,
    "data-test-subj": "case-severity-filter"
  });
};
exports.SeverityFilter = SeverityFilter;
SeverityFilter.displayName = 'SeverityFilter';