"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllCasesSelectorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _all_cases_list = require("../all_cases_list");
var _query_client = require("../../cases_context/query_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Modal = (0, _styledComponents.default)(_eui.EuiModal)`
  ${({
  theme
}) => `
    min-width: ${theme.eui.euiBreakpoints.m};
    max-width: ${theme.eui.euiBreakpoints.xl};
  `}
`;
const AllCasesSelectorModal = /*#__PURE__*/_react.default.memo(({
  hiddenStatuses,
  onRowClick,
  onClose
}) => {
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(true);
  const closeModal = (0, _react.useCallback)(() => {
    if (onClose) {
      onClose();
    }
    setIsModalOpen(false);
  }, [onClose]);
  const onClick = (0, _react.useCallback)(theCase => {
    closeModal();
    if (onRowClick) {
      onRowClick(theCase);
    }
  }, [closeModal, onRowClick]);
  return isModalOpen ? /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.casesQueryClient
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(Modal, {
    onClose: closeModal,
    "data-test-subj": "all-cases-modal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.SELECT_CASE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_all_cases_list.AllCasesList, {
    hiddenStatuses: hiddenStatuses,
    isSelectorView: true,
    onRowClick: onClick
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: closeModal,
    "data-test-subj": "all-cases-modal-cancel-button"
  }, i18n.CANCEL)))) : null;
});
exports.AllCasesSelectorModal = AllCasesSelectorModal;
AllCasesSelectorModal.displayName = 'AllCasesSelectorModal';