"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _prettyMs = _interopRequireDefault(require("pretty-ms"));
var _api = require("../../../common/api");
var _use_get_cases_status = require("../../containers/use_get_cases_status");
var _status_stats = require("../status/status_stats");
var _use_get_cases_metrics = require("../../containers/use_get_cases_metrics");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsFlexGroup = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    border: ${theme.eui.euiBorderThin};
    border-radius: ${theme.eui.euiBorderRadius};
    padding: ${theme.eui.euiSizeM};
    margin-bottom: ${theme.eui.euiSizeL};
  `}
`;
const CasesMetrics = () => {
  const {
    data: {
      countOpenCases,
      countInProgressCases,
      countClosedCases
    } = {
      countOpenCases: 0,
      countInProgressCases: 0,
      countClosedCases: 0
    },
    isLoading: isCasesStatusLoading
  } = (0, _use_get_cases_status.useGetCasesStatus)();
  const {
    data: {
      mttr
    } = {
      mttr: 0
    },
    isLoading: isCasesMetricsLoading
  } = (0, _use_get_cases_metrics.useGetCasesMetrics)();
  const mttrValue = (0, _react.useMemo)(() => mttr != null ? (0, _prettyMs.default)(mttr * 1000, {
    compact: true,
    verbose: false
  }) : '-', [mttr]);
  return /*#__PURE__*/_react.default.createElement(MetricsFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    "data-test-subj": "cases-metrics-stats"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "openStatsHeader",
    caseCount: countOpenCases,
    caseStatus: _api.CaseStatuses.open,
    isLoading: isCasesStatusLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "inProgressStatsHeader",
    caseCount: countInProgressCases,
    caseStatus: _api.CaseStatuses['in-progress'],
    isLoading: isCasesStatusLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "closedStatsHeader",
    caseCount: countClosedCases,
    caseStatus: _api.CaseStatuses.closed,
    isLoading: isCasesStatusLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": 'mttrStatsHeader',
    textStyle: "reverse",
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: _translations.ATTC_DESCRIPTION
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.ATTC_STAT, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "questionInCircle"
      }))),
      description: isCasesMetricsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        "data-test-subj": `mttr-stat-loading-spinner`
      }) : mttrValue
    }]
  }))));
};
exports.CasesMetrics = CasesMetrics;
CasesMetrics.displayName = 'CasesMetrics';