"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_ASSIGNEES_VALUE = exports.AssigneesFilterPopover = void 0;
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_is_user_typing = require("../../common/use_is_user_typing");
var _use_suggest_user_profiles = require("../../containers/user_profiles/use_suggest_user_profiles");
var _use_available_owners = require("../app/use_available_owners");
var _use_cases_context = require("../cases_context/use_cases_context");
var _empty_message = require("../user_profiles/empty_message");
var _no_matches = require("../user_profiles/no_matches");
var _sort = require("../user_profiles/sort");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_ASSIGNEES_VALUE = null;
exports.NO_ASSIGNEES_VALUE = NO_ASSIGNEES_VALUE;
const AssigneesFilterPopoverComponent = ({
  selectedAssignees,
  currentUserProfile,
  isLoading,
  onSelectionChange
}) => {
  const {
    owner: owners
  } = (0, _use_cases_context.useCasesContext)();
  const hasOwners = owners.length > 0;
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)(['read']);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    isUserTyping,
    onContentChange,
    onDebounce
  } = (0, _use_is_user_typing.useIsUserTyping)();
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const onChange = (0, _react.useCallback)(users => {
    const sortedUsers = (0, _sort.orderAssigneesIncludingNone)(currentUserProfile, users);
    onSelectionChange(sortedUsers);
  }, [currentUserProfile, onSelectionChange]);
  const selectedStatusMessage = (0, _react.useCallback)(selectedCount => i18n.TOTAL_ASSIGNEES_FILTERED(selectedCount), []);
  const onSearchChange = (0, _react.useCallback)(term => {
    setSearchTerm(term);
    onContentChange(term);
  }, [onContentChange]);
  const {
    data: userProfiles,
    isLoading: isLoadingSuggest
  } = (0, _use_suggest_user_profiles.useSuggestUserProfiles)({
    name: searchTerm,
    owners: hasOwners ? owners : availableOwners,
    onDebounce
  });
  const searchResultProfiles = (0, _react.useMemo)(() => {
    var _bringCurrentUserToFr;
    const sortedUsers = (_bringCurrentUserToFr = (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, userProfiles)) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
    if ((0, _lodash.isEmpty)(searchTerm)) {
      return [null, ...sortedUsers];
    }
    return sortedUsers;
  }, [currentUserProfile, userProfiles, searchTerm]);
  const isLoadingData = isLoading || isLoadingSuggest;
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesPopover, {
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    panelStyle: {
      minWidth: 520
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "options-filter-popover-button-assignees",
      iconType: "arrowDown",
      onClick: togglePopover,
      isLoading: isLoadingData,
      isSelected: isPopoverOpen,
      hasActiveFilters: selectedAssignees.length > 0,
      numActiveFilters: selectedAssignees.length,
      "aria-label": i18n.FILTER_ASSIGNEES_ARIA_LABEL
    }, i18n.ASSIGNEES),
    selectableProps: {
      onChange,
      onSearchChange,
      selectedStatusMessage,
      options: searchResultProfiles,
      selectedOptions: selectedAssignees,
      isLoading: isLoadingData || isUserTyping,
      height: 'full',
      searchPlaceholder: i18n.SEARCH_USERS,
      clearButtonLabel: i18n.CLEAR_FILTERS,
      emptyMessage: /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, null),
      noMatchesMessage: !isUserTyping && !isLoadingData ? /*#__PURE__*/_react.default.createElement(_no_matches.NoMatches, null) : /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, null),
      singleSelection: false,
      nullOptionLabel: i18n.NO_ASSIGNEES
    }
  });
};
AssigneesFilterPopoverComponent.displayName = 'AssigneesFilterPopover';
const AssigneesFilterPopover = /*#__PURE__*/_react.default.memo(AssigneesFilterPopoverComponent);
exports.AssigneesFilterPopover = AssigneesFilterPopover;