"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _empty_value = require("../empty_value");
var _user_tooltip = require("../user_profiles/user_tooltip");
var _use_assignees = require("../../containers/user_profiles/use_assignees");
var _data_test_subject = require("../user_profiles/data_test_subject");
var _small_user_avatar = require("../user_profiles/small_user_avatar");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPRESSED_AVATAR_LIMIT = 3;
const AssigneesColumnComponent = ({
  assignees,
  userProfiles,
  compressedDisplayLimit = COMPRESSED_AVATAR_LIMIT
}) => {
  const [isAvatarListExpanded, setIsAvatarListExpanded] = (0, _react.useState)(false);
  const {
    allAssignees
  } = (0, _use_assignees.useAssignees)({
    caseAssignees: assignees,
    userProfiles
  });
  const toggleExpandedAvatars = (0, _react.useCallback)(() => setIsAvatarListExpanded(prevState => !prevState), []);
  const numHiddenAvatars = allAssignees.length - compressedDisplayLimit;
  const shouldShowExpandListButton = numHiddenAvatars > 0;
  const limitedAvatars = (0, _react.useMemo)(() => allAssignees.slice(0, compressedDisplayLimit), [allAssignees, compressedDisplayLimit]);
  const avatarsToDisplay = (0, _react.useMemo)(() => {
    if (isAvatarListExpanded || !shouldShowExpandListButton) {
      return allAssignees;
    }
    return limitedAvatars;
  }, [allAssignees, isAvatarListExpanded, limitedAvatars, shouldShowExpandListButton]);
  if (allAssignees.length <= 0) {
    return (0, _empty_value.getEmptyTagValue)();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": "case-table-column-assignee",
    wrap: true
  }, avatarsToDisplay.map(assignee => {
    const dataTestSubjName = (0, _data_test_subject.getUsernameDataTestSubj)(assignee);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: assignee.uid,
      "data-test-subj": `case-table-column-assignee-${dataTestSubjName}`
    }, /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
      userInfo: assignee.profile
    }, /*#__PURE__*/_react.default.createElement(_small_user_avatar.SmallUserAvatar, {
      userInfo: assignee.profile
    })));
  }), shouldShowExpandListButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "case-table-column-expand-button",
    onClick: toggleExpandedAvatars,
    style: {
      alignSelf: 'center'
    }
  }, isAvatarListExpanded ? i18n.SHOW_LESS : i18n.SHOW_MORE(numHiddenAvatars)) : null);
};
AssigneesColumnComponent.displayName = 'AssigneesColumn';
const AssigneesColumn = /*#__PURE__*/_react.default.memo(AssigneesColumnComponent);
exports.AssigneesColumn = AssigneesColumn;