"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SET_SEVERITY_MEDIUM = exports.SET_SEVERITY_LOW = exports.SET_SEVERITY_HIGH = exports.SET_SEVERITY_CRITICAL = void 0;
var _i18n = require("@kbn/i18n");
var _api = require("../../../../common/api");
var _config = require("../../severity/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SET_SEVERITY = ({
  totalCases,
  severity,
  caseTitle
}) => _i18n.i18n.translate('xpack.cases.actions.severity', {
  values: {
    caseTitle,
    totalCases,
    severity
  },
  defaultMessage: '{totalCases, plural, =1 {Case "{caseTitle}" was} other {{totalCases} cases were}} set to {severity}'
});
const SET_SEVERITY_LOW = ({
  totalCases,
  caseTitle
}) => SET_SEVERITY({
  totalCases,
  caseTitle,
  severity: _config.severities[_api.CaseSeverity.LOW].label
});
exports.SET_SEVERITY_LOW = SET_SEVERITY_LOW;
const SET_SEVERITY_MEDIUM = ({
  totalCases,
  caseTitle
}) => SET_SEVERITY({
  totalCases,
  caseTitle,
  severity: _config.severities[_api.CaseSeverity.MEDIUM].label
});
exports.SET_SEVERITY_MEDIUM = SET_SEVERITY_MEDIUM;
const SET_SEVERITY_HIGH = ({
  totalCases,
  caseTitle
}) => SET_SEVERITY({
  totalCases,
  caseTitle,
  severity: _config.severities[_api.CaseSeverity.HIGH].label
});
exports.SET_SEVERITY_HIGH = SET_SEVERITY_HIGH;
const SET_SEVERITY_CRITICAL = ({
  totalCases,
  caseTitle
}) => SET_SEVERITY({
  totalCases,
  caseTitle,
  severity: _config.severities[_api.CaseSeverity.CRITICAL].label
});
exports.SET_SEVERITY_CRITICAL = SET_SEVERITY_CRITICAL;