"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAssigneesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _edit_assignees_selectable = require("./edit_assignees_selectable");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  ${(0, _eui.euiFullHeight)()}

  .euiFlyoutBody__overflowContent {
    ${(0, _eui.euiFullHeight)()}
  }
`;
const EditAssigneesFlyoutComponent = ({
  selectedCases,
  onClose,
  onSaveAssignees
}) => {
  const [assigneesSelection, setAssigneesSelection] = (0, _react.useState)({
    selectedItems: [],
    unSelectedItems: []
  });
  const onSave = (0, _react.useCallback)(() => onSaveAssignees(assigneesSelection), [onSaveAssignees, assigneesSelection]);
  const headerSubtitle = selectedCases.length > 1 ? i18n.SELECTED_CASES(selectedCases.length) : selectedCases[0].title;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": "cases-edit-assignees-flyout",
    "data-test-subj": "cases-edit-assignees-flyout",
    size: "s",
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "cases-edit-assignees-flyout-title"
  }, i18n.EDIT_ASSIGNEES)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, headerSubtitle))), /*#__PURE__*/_react.default.createElement(FlyoutBody, null, /*#__PURE__*/_react.default.createElement(_edit_assignees_selectable.EditAssigneesSelectable, {
    selectedCases: selectedCases,
    onChangeAssignees: setAssigneesSelection
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "cases-edit-assignees-flyout-cancel"
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    "data-test-subj": "cases-edit-assignees-flyout-submit"
  }, i18n.SAVE_SELECTION)))));
};
EditAssigneesFlyoutComponent.displayName = 'EditAssigneesFlyout';
const EditAssigneesFlyout = /*#__PURE__*/_react.default.memo(EditAssigneesFlyoutComponent);
exports.EditAssigneesFlyout = EditAssigneesFlyout;