"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesToast = exports.CaseToastSuccessContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/kibana-react-plugin/public");
var _owner = require("../../common/utils/owner");
var _common = require("../../common");
var _kibana = require("./lib/kibana");
var _navigation = require("./navigation");
var _translations = require("./translations");
var _constants = require("../../common/constants");
var _use_cases_context = require("../components/cases_context/use_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const Title = _styledComponents.default.span`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: break-word;
`;
const EuiTextStyled = (0, _styledComponents.default)(_eui.EuiText)`
  ${({
  theme
}) => {
  var _theme$eui$paddingSiz, _theme$eui, _theme$eui$paddingSiz2;
  return `
    margin-bottom: ${(_theme$eui$paddingSiz = (_theme$eui = theme.eui) === null || _theme$eui === void 0 ? void 0 : (_theme$eui$paddingSiz2 = _theme$eui.paddingSizes) === null || _theme$eui$paddingSiz2 === void 0 ? void 0 : _theme$eui$paddingSiz2.s) !== null && _theme$eui$paddingSiz !== void 0 ? _theme$eui$paddingSiz : 8}px;
  `;
}}
`;
function getAlertsCount(attachments) {
  let alertsCount = 0;
  for (const attachment of attachments) {
    if (attachment.type === _common.CommentType.alert) {
      // alertId might be an array
      if (Array.isArray(attachment.alertId) && attachment.alertId.length > 1) {
        alertsCount += attachment.alertId.length;
      } else {
        // or might be a single string
        alertsCount++;
      }
    }
  }
  return alertsCount;
}
function getToastTitle({
  theCase,
  title,
  attachments
}) {
  if (title !== undefined) {
    return title;
  }
  if (attachments !== undefined) {
    const alertsCount = getAlertsCount(attachments);
    if (alertsCount > 0) {
      return (0, _translations.CASE_ALERT_SUCCESS_TOAST)(theCase.title, alertsCount);
    }
  }
  return (0, _translations.CASE_SUCCESS_TOAST)(theCase.title);
}
function getToastContent({
  theCase,
  content,
  attachments
}) {
  if (content !== undefined) {
    return content;
  }
  if (attachments !== undefined) {
    for (const attachment of attachments) {
      if (attachment.type === _common.CommentType.alert && theCase.settings.syncAlerts) {
        return _translations.CASE_ALERT_SUCCESS_SYNC_TEXT;
      }
    }
  }
  return undefined;
}
const isServerError = error => Object.hasOwn(error, 'body');
const getError = error => {
  if (isServerError(error)) {
    var _error$body;
    return new Error((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message);
  }
  return error;
};
const getErrorMessage = error => {
  if (isServerError(error)) {
    var _error$body$message, _error$body2;
    return (_error$body$message = (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message !== void 0 ? _error$body$message : '';
  }
  return error.message;
};
const useCasesToast = () => {
  const {
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getUrlForApp,
    navigateToUrl
  } = (0, _kibana.useKibana)().services.application;
  const toasts = (0, _kibana.useToasts)();
  return {
    showSuccessAttach: ({
      theCase,
      attachments,
      title,
      content
    }) => {
      const appIdToNavigateTo = (0, _owner.isValidOwner)(theCase.owner) ? _constants.OWNER_INFO[theCase.owner].appId : appId;
      const url = getUrlForApp(appIdToNavigateTo, {
        deepLinkId: 'cases',
        path: (0, _navigation.generateCaseViewPath)({
          detailName: theCase.id
        })
      });
      const onViewCaseClick = () => {
        navigateToUrl(url);
      };
      const renderTitle = getToastTitle({
        theCase,
        title,
        attachments
      });
      const renderContent = getToastContent({
        theCase,
        content,
        attachments
      });
      return toasts.addSuccess({
        color: 'success',
        iconType: 'check',
        title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(Title, null, renderTitle)),
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(CaseToastSuccessContent, {
          content: renderContent,
          onViewCaseClick: onViewCaseClick
        }))
      });
    },
    showErrorToast: (error, opts) => {
      if (error.name !== 'AbortError') {
        toasts.addError(getError(error), {
          title: getErrorMessage(error),
          ...opts
        });
      }
    },
    showSuccessToast: title => {
      toasts.addSuccess({
        title,
        className: 'eui-textBreakWord'
      });
    },
    showDangerToast: title => {
      toasts.addDanger({
        title,
        className: 'eui-textBreakWord'
      });
    },
    showInfoToast: (title, text) => {
      toasts.addInfo({
        title,
        text,
        className: 'eui-textBreakWord'
      });
    }
  };
};
exports.useCasesToast = useCasesToast;
const CaseToastSuccessContent = ({
  onViewCaseClick,
  content
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content !== undefined ? /*#__PURE__*/_react.default.createElement(EuiTextStyled, {
    size: "s",
    "data-test-subj": "toaster-content-sync-text"
  }, content) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    onClick: onViewCaseClick,
    "data-test-subj": "toaster-content-case-view-link"
  }, _translations.VIEW_CASE));
};
exports.CaseToastSuccessContent = CaseToastSuccessContent;
CaseToastSuccessContent.displayName = 'CaseToastSuccessContent';