"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeExternalLinkText = exports.createQueryWithMarkup = void 0;
exports.waitForComponentToPaint = waitForComponentToPaint;
exports.waitForComponentToUpdate = void 0;
var _testUtils = require("react-dom/test-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Convenience utility to remove text appended to links by EUI
 */
const removeExternalLinkText = str => str === null || str === void 0 ? void 0 : str.replace(/\(opens in a new tab or window\)/g, '');
exports.removeExternalLinkText = removeExternalLinkText;
async function waitForComponentToPaint(wrapper, amount = 0) {
  await (0, _testUtils.act)(async () => {
    await new Promise(resolve => setTimeout(resolve, amount));
    wrapper.update();
  });
}
const waitForComponentToUpdate = async () => (0, _testUtils.act)(async () => {
  return Promise.resolve();
});
exports.waitForComponentToUpdate = waitForComponentToUpdate;
const createQueryWithMarkup = query => text => query((content, node) => {
  var _node$children;
  const hasText = el => (el === null || el === void 0 ? void 0 : el.textContent) === text;
  const childrenDontHaveText = Array.from((_node$children = node === null || node === void 0 ? void 0 : node.children) !== null && _node$children !== void 0 ? _node$children : []).every(child => !hasText(child));
  return hasText(node) && childrenDontHaveText;
});
exports.createQueryWithMarkup = createQueryWithMarkup;