"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateCasePath = exports.getCasesConfigurePath = exports.getCaseViewWithCommentPath = exports.getCaseViewPath = exports.generateCaseViewPath = exports.DEFAULT_BASE_PATH = void 0;
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BASE_PATH = '/cases';
exports.DEFAULT_BASE_PATH = DEFAULT_BASE_PATH;
const normalizePath = path => path.replaceAll('//', '/');
const getCreateCasePath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASES_CREATE_PATH}`);
exports.getCreateCasePath = getCreateCasePath;
const getCasesConfigurePath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASES_CONFIGURE_PATH}`);
exports.getCasesConfigurePath = getCasesConfigurePath;
const getCaseViewPath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASE_VIEW_PATH}`);
exports.getCaseViewPath = getCaseViewPath;
const getCaseViewWithCommentPath = casesBasePath => normalizePath(`${casesBasePath}${_constants.CASE_VIEW_COMMENT_PATH}`);
exports.getCaseViewWithCommentPath = getCaseViewWithCommentPath;
const generateCaseViewPath = params => {
  const {
    commentId,
    tabId
  } = params;
  // Cast for generatePath argument type constraint
  const pathParams = params;

  // paths with commentId have their own specific path.
  // Effectively overwrites the tabId
  if (commentId) {
    return normalizePath((0, _reactRouterDom.generatePath)(_constants.CASE_VIEW_COMMENT_PATH, pathParams));
  }
  if (tabId !== undefined) {
    return normalizePath((0, _reactRouterDom.generatePath)(_constants.CASE_VIEW_TAB_PATH, pathParams));
  }
  return normalizePath((0, _reactRouterDom.generatePath)(_constants.CASE_VIEW_PATH, pathParams));
};
exports.generateCaseViewPath = generateCaseViewPath;