"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesDeepLinks = exports.CasesDeepLinkId = void 0;
var _i18n = require("@kbn/i18n");
var _paths = require("./paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesDeepLinkId = {
  cases: 'cases',
  casesCreate: 'cases_create',
  casesConfigure: 'cases_configure'
};
exports.CasesDeepLinkId = CasesDeepLinkId;
const getCasesDeepLinks = ({
  basePath = _paths.DEFAULT_BASE_PATH,
  extend = {}
}) => {
  var _extend$CasesDeepLink, _extend$CasesDeepLink2, _extend$CasesDeepLink3;
  return {
    title: _i18n.i18n.translate('xpack.cases.navigation.cases', {
      defaultMessage: 'Cases'
    }),
    ...((_extend$CasesDeepLink = extend[CasesDeepLinkId.cases]) !== null && _extend$CasesDeepLink !== void 0 ? _extend$CasesDeepLink : {}),
    id: CasesDeepLinkId.cases,
    path: basePath,
    deepLinks: [{
      title: _i18n.i18n.translate('xpack.cases.navigation.create', {
        defaultMessage: 'Create New Case'
      }),
      ...((_extend$CasesDeepLink2 = extend[CasesDeepLinkId.casesCreate]) !== null && _extend$CasesDeepLink2 !== void 0 ? _extend$CasesDeepLink2 : {}),
      id: CasesDeepLinkId.casesCreate,
      path: (0, _paths.getCreateCasePath)(basePath)
    }, {
      title: _i18n.i18n.translate('xpack.cases.navigation.configure', {
        defaultMessage: 'Configure Cases'
      }),
      ...((_extend$CasesDeepLink3 = extend[CasesDeepLinkId.casesConfigure]) !== null && _extend$CasesDeepLink3 !== void 0 ? _extend$CasesDeepLink3 : {}),
      id: CasesDeepLinkId.casesConfigure,
      path: (0, _paths.getCasesConfigurePath)(basePath)
    }]
  };
};
exports.getCasesDeepLinks = getCasesDeepLinks;