"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _app = require("./components/app");
var _use_is_dark_theme = require("./common/use_is_dark_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = deps => {
  const {
    mountParams
  } = deps;
  const {
    element
  } = mountParams;
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(App, {
    deps: deps
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const CasesAppWithContext = /*#__PURE__*/_react.default.memo(({
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  getFilesClient
}) => {
  const isDarkTheme = (0, _use_is_dark_theme.useIsDarkTheme)();
  return /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkTheme
  }, /*#__PURE__*/_react.default.createElement(_app.CasesApp, {
    externalReferenceAttachmentTypeRegistry: externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry: persistableStateAttachmentTypeRegistry,
    getFilesClient: getFilesClient
  }));
});
CasesAppWithContext.displayName = 'CasesAppWithContext';
const App = ({
  deps
}) => {
  const {
    mountParams,
    coreStart,
    pluginsStart,
    storage,
    kibanaVersion
  } = deps;
  const {
    history,
    theme$
  } = mountParams;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      kibanaVersion,
      ...coreStart,
      ...pluginsStart,
      storage
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(CasesAppWithContext, {
    externalReferenceAttachmentTypeRegistry: deps.externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry: deps.persistableStateAttachmentTypeRegistry,
    getFilesClient: pluginsStart.files.filesClientFactory.asScoped
  }))))));
};
exports.App = App;
App.displayName = 'App';