"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeCasesStatusResponse = exports.decodeCasesMetricsResponse = exports.decodeCasesFindResponse = exports.decodeCasesBulkGetResponse = void 0;
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _utils = require("../containers/utils");
var _common = require("../../common");
var _api = require("../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const decodeCasesFindResponse = respCases => (0, _pipeable.pipe)(_api.CasesFindResponseRt.decode(respCases), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
exports.decodeCasesFindResponse = decodeCasesFindResponse;
const decodeCasesStatusResponse = respCase => (0, _pipeable.pipe)(_api.CasesStatusResponseRt.decode(respCase), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
exports.decodeCasesStatusResponse = decodeCasesStatusResponse;
const decodeCasesMetricsResponse = metrics => (0, _pipeable.pipe)(_api.CasesMetricsResponseRt.decode(metrics), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
exports.decodeCasesMetricsResponse = decodeCasesMetricsResponse;
const decodeCasesBulkGetResponse = (res, fields) => {
  const typeToDecode = (0, _api.getTypeForCertainFieldsFromArray)(_api.CasesResponseRt, fields);
  (0, _pipeable.pipe)(typeToDecode.decode(res.cases), (0, _Either.fold)((0, _common.throwErrors)(_utils.createToasterPlainError), _function.identity));
  return res;
};
exports.decodeCasesBulkGetResponse = decodeCasesBulkGetResponse;