"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApiTags = void 0;
var _constants = require("../constants");
var _types = require("../constants/types");
var _files = require("../files");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApiTags = owner => {
  const create = (0, _files.constructFilesHttpOperationTag)(owner, _types.HttpApiTagOperation.Create);
  const deleteTag = (0, _files.constructFilesHttpOperationTag)(owner, _types.HttpApiTagOperation.Delete);
  const read = (0, _files.constructFilesHttpOperationTag)(owner, _types.HttpApiTagOperation.Read);
  return {
    all: [_constants.SUGGEST_USER_PROFILES_API_TAG, _constants.BULK_GET_USER_PROFILES_API_TAG, create, read],
    read: [_constants.SUGGEST_USER_PROFILES_API_TAG, _constants.BULK_GET_USER_PROFILES_API_TAG, read],
    delete: [deleteTag]
  };
};
exports.getApiTags = getApiTags;