"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.limitedArraySchema = exports.NonEmptyString = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/lib/Either");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NonEmptyString = new rt.Type('NonEmptyString', rt.string.is, (input, context) => _Either.either.chain(rt.string.validate(input, context), s => {
  if (s.trim() !== '') {
    return rt.success(s);
  } else {
    return rt.failure(input, context, 'string must have length >= 1');
  }
}), rt.identity);
exports.NonEmptyString = NonEmptyString;
const limitedArraySchema = (codec, min, max) => new rt.Type('LimitedArray', input => rt.array(codec).is(input), (input, context) => _Either.either.chain(rt.array(codec).validate(input, context), s => {
  if (s.length < min) {
    return rt.failure(input, context, `array must be of length >= ${min}`);
  }
  if (s.length > max) {
    return rt.failure(input, context, `array must be of length <= ${max}`);
  }
  return rt.success(s);
}), rt.identity);
exports.limitedArraySchema = limitedArraySchema;