"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionsRt = exports.CaseUserActionsResponseRt = exports.CaseUserActionsDeprecatedResponseRt = exports.CaseUserActionStatsResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
var _create_case = require("./create_case");
var _description = require("./description");
var _comment = require("./comment");
var _connector = require("./connector");
var _pushed = require("./pushed");
var _tags = require("./tags");
var _title = require("./title");
var _settings = require("./settings");
var _status = require("./status");
var _delete_case = require("./delete_case");
var _severity = require("./severity");
var _assignees = require("./assignees");
var _stats = require("./stats");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUserActionsRt = rt.union([_description.DescriptionUserActionRt, _comment.CommentUserActionRt, _tags.TagsUserActionRt, _title.TitleUserActionRt, _settings.SettingsUserActionRt, _status.StatusUserActionRt, _severity.SeverityUserActionRt, _assignees.AssigneesUserActionRt]);
const UserActionsRt = rt.union([CommonUserActionsRt, _create_case.CreateCaseUserActionRt, _connector.ConnectorUserActionRt, _pushed.PushedUserActionRt, _delete_case.DeleteCaseUserActionRt]);
exports.UserActionsRt = UserActionsRt;
const UserActionsWithoutConnectorIdRt = rt.union([CommonUserActionsRt, _create_case.CreateCaseUserActionWithoutConnectorIdRt, _connector.ConnectorUserActionWithoutConnectorIdRt, _pushed.PushedUserActionWithoutConnectorIdRt, _delete_case.DeleteCaseUserActionRt]);
const CaseUserActionBasicRt = rt.intersection([UserActionsRt, _common.UserActionCommonAttributesRt]);
const CaseUserActionBasicWithoutConnectorIdRt = rt.intersection([UserActionsWithoutConnectorIdRt, _common.UserActionCommonAttributesRt]);
const CaseUserActionDeprecatedResponseRt = rt.intersection([CaseUserActionBasicRt, _common.CaseUserActionInjectedDeprecatedIdsRt]);

/**
 * This includes the comment_id but not the action_id or case_id
 */
const CaseUserActionInjectedAttributesRt = rt.intersection([CaseUserActionBasicRt, _common.CaseUserActionInjectedIdsRt]);
const CaseUserActionResponseRt = rt.intersection([CaseUserActionInjectedAttributesRt, rt.type({
  id: rt.string,
  version: rt.string
})]);
const CaseUserActionAttributesRt = CaseUserActionBasicRt;
const CaseUserActionsResponseRt = rt.array(CaseUserActionResponseRt);
exports.CaseUserActionsResponseRt = CaseUserActionsResponseRt;
const CaseUserActionsDeprecatedResponseRt = rt.array(CaseUserActionDeprecatedResponseRt);
exports.CaseUserActionsDeprecatedResponseRt = CaseUserActionsDeprecatedResponseRt;
const CaseUserActionStatsResponseRt = _stats.CaseUserActionStatsRt;
exports.CaseUserActionStatsResponseRt = CaseUserActionStatsResponseRt;