"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleFileAttachmentMetadataRt = exports.FileAttachmentMetadataRt = exports.FILE_ATTACHMENT_TYPE = exports.BulkDeleteFileAttachmentsRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SingleFileAttachmentMetadataRt = rt.type({
  name: rt.string,
  extension: rt.string,
  mimeType: rt.string,
  created: rt.string
});
exports.SingleFileAttachmentMetadataRt = SingleFileAttachmentMetadataRt;
const FileAttachmentMetadataRt = rt.type({
  files: rt.array(SingleFileAttachmentMetadataRt)
});
exports.FileAttachmentMetadataRt = FileAttachmentMetadataRt;
const FILE_ATTACHMENT_TYPE = '.files';
exports.FILE_ATTACHMENT_TYPE = FILE_ATTACHMENT_TYPE;
const MIN_DELETE_IDS = 1;
const BulkDeleteFileAttachmentsRequestRt = rt.type({
  ids: (0, _schema.limitedArraySchema)(_schema.NonEmptyString, MIN_DELETE_IDS, _constants.MAX_DELETE_FILES)
});
exports.BulkDeleteFileAttachmentsRequestRt = BulkDeleteFileAttachmentsRequestRt;