"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elementStats = void 0;
var _transient = require("../actions/transient");
var _workpad = require("../selectors/workpad");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const elementStats = ({
  dispatch,
  getState
}) => next => action => {
  // execute the action
  next(action);

  // read the new state
  const state = getState();
  const stats = (0, _workpad.getElementStats)(state);
  const total = (0, _workpad.getAllElements)(state).length;
  const counts = (0, _workpad.getElementCounts)(state);
  const {
    ready,
    error
  } = counts;

  // TODO: this should come from getElementStats, once we've gotten element status fixed
  const pending = total - ready - error;
  if ((total > 0 || stats.total > 0) && (ready !== stats.ready || pending !== stats.pending || error !== stats.error || total !== stats.total)) {
    dispatch((0, _transient.setElementStats)({
      total,
      ready,
      pending,
      error
    }));
  }
};
exports.elementStats = elementStats;