"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateWorkpadVariables = exports.sizeWorkpad = exports.setWriteable = exports.setWorkpadVariables = exports.setWorkpadCSS = exports.setWorkpad = exports.setRefreshInterval = exports.setName = exports.setColors = exports.setAutoplayInterval = exports.resetWorkpad = exports.removeColor = exports.initializeWorkpad = exports.enableAutoplay = exports.addColor = void 0;
var _reduxActions = require("redux-actions");
var _lodash = require("lodash");
var _create_thunk = require("../../lib/create_thunk");
var _workpad = require("../selectors/workpad");
var _elements = require("./elements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const sizeWorkpad = (0, _reduxActions.createAction)('sizeWorkpad');
exports.sizeWorkpad = sizeWorkpad;
const setName = (0, _reduxActions.createAction)('setName');
exports.setName = setName;
const setWriteable = (0, _reduxActions.createAction)('setWriteable');
exports.setWriteable = setWriteable;
const setColors = (0, _reduxActions.createAction)('setColors');
exports.setColors = setColors;
const setRefreshInterval = (0, _reduxActions.createAction)('setRefreshInterval');
exports.setRefreshInterval = setRefreshInterval;
const setWorkpadCSS = (0, _reduxActions.createAction)('setWorkpadCSS');
exports.setWorkpadCSS = setWorkpadCSS;
const setWorkpadVariables = (0, _reduxActions.createAction)('setWorkpadVariables');
exports.setWorkpadVariables = setWorkpadVariables;
const enableAutoplay = (0, _reduxActions.createAction)('enableAutoplay');
exports.enableAutoplay = enableAutoplay;
const setAutoplayInterval = (0, _reduxActions.createAction)('setAutoplayInterval');
exports.setAutoplayInterval = setAutoplayInterval;
const resetWorkpad = (0, _reduxActions.createAction)('resetWorkpad');
exports.resetWorkpad = resetWorkpad;
const initializeWorkpad = (0, _create_thunk.createThunk)('initializeWorkpad', ({
  dispatch
}) => {
  dispatch((0, _elements.fetchAllRenderables)());
});
exports.initializeWorkpad = initializeWorkpad;
const addColor = (0, _create_thunk.createThunk)('addColor', ({
  dispatch,
  getState
}, color) => {
  const colors = (0, _workpad.getWorkpadColors)(getState()).slice(0);
  if (!(0, _lodash.includes)(colors, color)) {
    colors.push(color);
  }
  dispatch(setColors(colors));
});
exports.addColor = addColor;
const removeColor = (0, _create_thunk.createThunk)('removeColor', ({
  dispatch,
  getState
}, color) => {
  dispatch(setColors((0, _lodash.without)((0, _workpad.getWorkpadColors)(getState()), color)));
});
exports.removeColor = removeColor;
const updateWorkpadVariables = (0, _create_thunk.createThunk)('updateWorkpadVariables', ({
  dispatch
}, vars) => {
  dispatch(setWorkpadVariables(vars));
  dispatch((0, _elements.fetchAllRenderables)());
});
exports.updateWorkpadVariables = updateWorkpadVariables;
const setWorkpad = (0, _create_thunk.createThunk)('setWorkpad', ({
  dispatch,
  type
}, workpad, {
  loadPages = true
} = {}) => {
  dispatch((0, _reduxActions.createAction)(type)(workpad)); // set the workpad object in state
  if (loadPages) {
    dispatch(initializeWorkpad());
  }
});
exports.setWorkpad = setWorkpad;