"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.platformServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noop = (..._args) => {};
const uiSettings = {
  dateFormat: 'MMM D, YYYY @ HH:mm:ss.SSS'
};
const getUISetting = setting => uiSettings[setting];
const platformServiceFactory = () => ({
  getBasePath: () => '/base/path',
  getBasePathInterface: noop,
  getDocLinkVersion: () => 'docLinkVersion',
  getElasticWebsiteUrl: () => 'https://elastic.co',
  getKibanaVersion: () => 'kibanaVersion',
  getHasWriteAccess: () => true,
  getUISetting,
  hasHeaderBanner$: noop,
  setBreadcrumbs: noop,
  setRecentlyAccessed: noop,
  getSavedObjects: noop,
  getSavedObjectsClient: noop,
  getUISettings: noop,
  setFullscreen: noop,
  redirectLegacyUrl: noop,
  getLegacyUrlConflict: undefined,
  getHttp: noop,
  getSavedObjectsManagement: noop
});
exports.platformServiceFactory = platformServiceFactory;