"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expressionsServiceFactory = void 0;
var _public = require("@kbn/expressions-plugin/public");
var _common = require("../../../canvas_plugin_src/functions/common");
var _core = require("../../../canvas_plugin_src/renderers/core");
var _expressions = require("../kibana/expressions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expressionsServiceFactory = (params, requiredServices) => {
  const placeholder = {};
  const expressionsPlugin = (0, _public.plugin)(placeholder);
  const setup = expressionsPlugin.setup(placeholder);
  const fork = setup.fork('canvas');
  const expressionsService = fork.setup();
  _common.functions.forEach(fn => expressionsService.registerFunction(fn));
  _core.renderFunctions.forEach(fn => {
    setup.registerRenderer(fn);
  });
  return new _expressions.ExpressionsService(fork.start(), requiredServices);
};
exports.expressionsServiceFactory = expressionsServiceFactory;