"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stubs = exports.startServices = void 0;
var _ = require("..");
var _search = require("./search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stubs = {
  search: _search.searchService
};
exports.stubs = stubs;
const startServices = async (providedServices = {}) => {
  Object.entries(_.services).forEach(([key, provider]) => {
    // @ts-expect-error Object.entries isn't strongly typed
    const stub = providedServices[key] || stubs[key];
    provider.setService(stub);
  });
};
exports.startServices = startServices;