"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadPresentationHelper = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _breadcrumbs = require("../../lib/breadcrumbs");
var _doc_title = require("../../lib/doc_title");
var _workpad = require("../../state/selectors/workpad");
var _use_fullscreen_presentation_helper = require("./hooks/use_fullscreen_presentation_helper");
var _use_autoplay_helper = require("./hooks/use_autoplay_helper");
var _use_refresh_helper = require("./hooks/use_refresh_helper");
var _services = require("../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWorkpadLabel = () => _i18n.i18n.translate('xpack.canvas.workpadConflict.redirectLabel', {
  defaultMessage: 'Workpad'
});
const WorkpadPresentationHelper = ({
  children
}) => {
  var _platformService$getL;
  const platformService = (0, _services.usePlatformService)();
  const workpad = (0, _reactRedux.useSelector)(_workpad.getWorkpad);
  (0, _use_fullscreen_presentation_helper.useFullscreenPresentationHelper)();
  (0, _use_autoplay_helper.useAutoplayHelper)();
  (0, _use_refresh_helper.useRefreshHelper)();
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    platformService.setBreadcrumbs([(0, _breadcrumbs.getBaseBreadcrumb)(history), (0, _breadcrumbs.getWorkpadBreadcrumb)({
      name: workpad.name
    })]);
  }, [workpad.name, platformService, history]);
  (0, _react.useEffect)(() => {
    (0, _doc_title.setDocTitle)(workpad.name || (0, _doc_title.getUntitledWorkpadLabel)());
  }, [workpad.name, workpad.id]);
  const conflictElement = workpad.aliasId ? (_platformService$getL = platformService.getLegacyUrlConflict) === null || _platformService$getL === void 0 ? void 0 : _platformService$getL.call(platformService, {
    objectNoun: getWorkpadLabel(),
    currentObjectId: workpad.id,
    otherObjectId: workpad.aliasId,
    otherObjectPath: `/workpad/${workpad.aliasId}`
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, conflictElement, children);
};
exports.WorkpadPresentationHelper = WorkpadPresentationHelper;