"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CanvasRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _queryString = require("query-string");
var _home = require("./home");
var _workpad = require("./workpad");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isHashPath = hash => {
  return hash.indexOf('#/') === 0;
};
const mergeQueryStrings = (query, queryFromHash) => {
  const queryObject = (0, _queryString.parse)(query);
  const hashObject = (0, _queryString.parse)(queryFromHash);
  return (0, _queryString.stringify)({
    ...queryObject,
    ...hashObject
  });
};
const CanvasRouter = ({
  history
}) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: "/",
  children: route => {
    // If it looks like the hash is a route then we will do a redirect
    if (isHashPath(route.location.hash) && !route.location.pathname) {
      const [hashPath, hashQuery] = route.location.hash.split('?');
      let search = route.location.search || '?';
      if (hashQuery !== undefined) {
        search = mergeQueryStrings(search, `?${hashQuery}`);
      }
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        push: true,
        to: {
          pathname: `${hashPath.substring(1)}`,
          search
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, (0, _workpad.ExportWorkpadRoute)(), (0, _workpad.WorkpadRoute)(), (0, _home.HomeRoute)());
  }
}));
exports.CanvasRouter = CanvasRouter;