"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSessionStorage = exports.getLocalStorage = exports.StorageType = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _get_window = require("./get_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let StorageType;
exports.StorageType = StorageType;
(function (StorageType) {
  StorageType["Local"] = "localStorage";
  StorageType["Session"] = "sessionStorage";
})(StorageType || (exports.StorageType = StorageType = {}));
const storages = {
  [StorageType.Local]: null,
  [StorageType.Session]: null
};
const getStorage = type => {
  const storage = storages[type] || new _public.Storage((0, _get_window.getWindow)()[type]);
  storages[type] = storage;
  return storage;
};
const getLocalStorage = () => {
  return getStorage(StorageType.Local);
};
exports.getLocalStorage = getLocalStorage;
const getSessionStorage = () => {
  return getStorage(StorageType.Session);
};
exports.getSessionStorage = getSessionStorage;