"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isExpressionWithFilters = exports.groupFiltersBy = exports.getFiltersExprsFromExpression = exports.getFiltersByFilterExpressions = exports.formatFilterView = exports.flattenFilterView = exports.defaultFormatter = exports.createFilledFilterView = void 0;
var _interpreter = require("@kbn/interpreter");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECT_FILTER = 'selectFilter';
const FILTERS = 'filters';
const REMOVE_FILTER = 'removeFilter';
const includeFiltersExpressions = [FILTERS, SELECT_FILTER];
const excludeFiltersExpressions = [REMOVE_FILTER];
const filtersExpressions = [...includeFiltersExpressions, ...excludeFiltersExpressions];
const defaultFormatter = value => value || null ? `${value}` : '-';
exports.defaultFormatter = defaultFormatter;
const formatFilterView = filterValue => filterView => {
  const filterViewKeys = Object.keys(filterView);
  return filterViewKeys.reduce((acc, key) => {
    var _filterView$key$forma;
    return {
      ...acc,
      [key]: {
        label: filterView[key].label,
        formattedValue: ((_filterView$key$forma = filterView[key].formatter) !== null && _filterView$key$forma !== void 0 ? _filterView$key$forma : defaultFormatter)(filterValue[key]),
        component: filterView[key].component
      }
    };
  }, {});
};
exports.formatFilterView = formatFilterView;
const flattenFilterView = filterValue => filterView => {
  const filterViewKeys = Object.keys(filterView);
  return filterViewKeys.reduce((acc, key) => {
    const filterField = filterView[key];
    if (typeof filterField === 'function') {
      const val = filterField(filterValue[key]);
      return {
        ...acc,
        ...val
      };
    }
    return {
      ...acc,
      [key]: filterField
    };
  }, {});
};
exports.flattenFilterView = flattenFilterView;
const createFilledFilterView = (filterView, filter) => (0, _lodash.flowRight)(formatFilterView(filter), flattenFilterView(filter))(filterView);
exports.createFilledFilterView = createFilledFilterView;
const groupFiltersBy = (filters, groupByField) => {
  const groupedFilters = (0, _lodash.groupBy)(filters, filter => filter[groupByField]);
  return Object.keys(groupedFilters).map(key => {
    var _groupedFilters$key, _groupedFilters$key$;
    return {
      name: (_groupedFilters$key = groupedFilters[key]) !== null && _groupedFilters$key !== void 0 && (_groupedFilters$key$ = _groupedFilters$key[0]) !== null && _groupedFilters$key$ !== void 0 && _groupedFilters$key$[groupByField] ? key : null,
      filters: groupedFilters[key]
    };
  });
};
exports.groupFiltersBy = groupFiltersBy;
const excludeFiltersByGroups = (filters, filterExprAst) => {
  var _filterExprAst$argume, _filterExprAst$argume2, _filterExprAst$argume3;
  const groupsToExclude = (_filterExprAst$argume = filterExprAst.arguments.group) !== null && _filterExprAst$argume !== void 0 ? _filterExprAst$argume : [];
  const removeUngrouped = (_filterExprAst$argume2 = (_filterExprAst$argume3 = filterExprAst.arguments.ungrouped) === null || _filterExprAst$argume3 === void 0 ? void 0 : _filterExprAst$argume3[0]) !== null && _filterExprAst$argume2 !== void 0 ? _filterExprAst$argume2 : false;
  return filters.filter(filter => {
    const groups = (0, _lodash.get)(filter, 'chain[0].arguments.filterGroup', []).filter(group => group !== '');
    const noNeedToExcludeByGroup = !(groups.length && groupsToExclude.length && groupsToExclude.includes(groups[0]));
    const noNeedToExcludeByUngrouped = removeUngrouped && groups.length || !removeUngrouped;
    const excludeAllFilters = !groupsToExclude.length && !removeUngrouped;
    return !excludeAllFilters && noNeedToExcludeByUngrouped && noNeedToExcludeByGroup;
  });
};
const includeFiltersByGroups = (filters, filterExprAst, ignoreUngroupedIfGroups = false) => {
  var _filterExprAst$argume4, _filterExprAst$argume5, _filterExprAst$argume6;
  const groupsToInclude = (_filterExprAst$argume4 = filterExprAst.arguments.group) !== null && _filterExprAst$argume4 !== void 0 ? _filterExprAst$argume4 : [];
  const includeOnlyUngrouped = (_filterExprAst$argume5 = (_filterExprAst$argume6 = filterExprAst.arguments.ungrouped) === null || _filterExprAst$argume6 === void 0 ? void 0 : _filterExprAst$argume6[0]) !== null && _filterExprAst$argume5 !== void 0 ? _filterExprAst$argume5 : false;
  return filters.filter(filter => {
    const groups = (0, _lodash.get)(filter, 'chain[0].arguments.filterGroup', []).filter(group => group !== '');
    const needToIncludeByGroup = groups.length && groupsToInclude.length && groupsToInclude.includes(groups[0]);
    const needToIncludeByUngrouped = includeOnlyUngrouped && !groups.length && (ignoreUngroupedIfGroups ? !groupsToInclude.length : true);
    const allowAll = !groupsToInclude.length && !includeOnlyUngrouped;
    return needToIncludeByUngrouped || needToIncludeByGroup || allowAll;
  });
};
const getFiltersByFilterExpressions = (filters, filterExprsAsts) => {
  const filtersAst = filters.map(filter => (0, _interpreter.fromExpression)(filter));
  const matchedFiltersAst = filterExprsAsts.reduce((includedFilters, filter) => {
    if (excludeFiltersExpressions.includes(filter.function)) {
      return excludeFiltersByGroups(includedFilters, filter);
    }
    const isFiltersExpr = filter.function === FILTERS;
    const filtersToInclude = isFiltersExpr ? filtersAst : includedFilters;
    return includeFiltersByGroups(filtersToInclude, filter, isFiltersExpr);
  }, filtersAst);
  return matchedFiltersAst.map(ast => (0, _interpreter.toExpression)(ast));
};
exports.getFiltersByFilterExpressions = getFiltersByFilterExpressions;
const getFiltersExprsFromExpression = expr => {
  const ast = (0, _interpreter.fromExpression)(expr);
  return ast.chain.filter(expression => filtersExpressions.includes(expression.function));
};
exports.getFiltersExprsFromExpression = getFiltersExprsFromExpression;
const isExpressionWithFilters = expr => {
  const ast = (0, _interpreter.fromExpression)(expr);
  return ast.chain.some(expression => filtersExpressions.includes(expression.function));
};
exports.isExpressionWithFilters = isExpressionWithFilters;