"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWorkpadBreadcrumb = exports.getBaseBreadcrumb = void 0;
var _doc_title = require("./doc_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const isLeftClickEvent = event => event.button === 0;
const isTargetBlank = event => {
  const target = event.target.getAttribute('target');
  return target && target !== '_self';
};
const getBaseBreadcrumb = history => {
  const path = '/';
  const href = history.createHref({
    pathname: path
  });
  const onClick = event => {
    if (event.defaultPrevented) {
      return;
    }

    // Let the browser handle links that open new tabs/windows
    if (isModifiedEvent(event) || !isLeftClickEvent(event) || isTargetBlank(event)) {
      return;
    }

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();

    // Push the route to the history.
    history.push(path);
  };
  return {
    text: 'Canvas',
    href,
    onClick
  };
};
exports.getBaseBreadcrumb = getBaseBreadcrumb;
const getWorkpadBreadcrumb = ({
  name
}) => ({
  text: name || (0, _doc_title.getUntitledWorkpadLabel)()
});
exports.getWorkpadBreadcrumb = getWorkpadBreadcrumb;