"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updater = exports.shapes = exports.nextScene = exports.focusedShape = void 0;
var _select = require("./select");
var _gestures = require("./gestures");
var _layout_functions = require("./layout_functions");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shapes = (0, _select.select)(_layout_functions.getShapes)(_common.scene);
exports.shapes = shapes;
const configuration = (0, _select.select)(_layout_functions.getConfiguration)(_common.scene);
const hoveredShapes = (0, _select.select)(_layout_functions.getHoveredShapes)(configuration, shapes, _gestures.cursorPosition);
const hoveredShape = (0, _select.select)(_layout_functions.getHoveredShape)(hoveredShapes);
const draggedShape = (0, _select.select)(_layout_functions.draggingShape)(_common.scene, hoveredShape, _gestures.mouseIsDown, _gestures.mouseDowned);
const focusedShape = (0, _select.select)(_layout_functions.getFocusedShape)(draggedShape, hoveredShape);
exports.focusedShape = focusedShape;
const alterSnapGesture = (0, _select.select)(_layout_functions.getAlterSnapGesture)(_gestures.metaHeld);
const multiselectModifier = _gestures.shiftHeld; // todo abstract out keybindings

const mouseTransformGesturePrev = (0, _select.select)(_layout_functions.getMouseTransformGesturePrev)(_common.scene);
const mouseTransformState = (0, _select.select)(_layout_functions.getMouseTransformState)(mouseTransformGesturePrev, _gestures.dragging, _gestures.dragVector);
const directManipulationTransformGestures = (0, _select.select)(_layout_functions.getMouseTransformGesture)(mouseTransformState);
const dragBox = (0, _select.select)(_layout_functions.getDragBox)(_gestures.dragging, draggedShape, _gestures.dragVector);
const selectedShapeObjects = (0, _select.select)(_layout_functions.getSelectedShapeObjects)(_common.scene, shapes);
const selectedShapesPrev = (0, _select.select)(_layout_functions.getSelectedShapesPrev)(_common.scene);
const boxHighlightedShapes = (0, _select.select)(_layout_functions.getDragboxHighlighted)(dragBox, shapes);
const selectionStateFull = (0, _select.select)(_layout_functions.getSelectionStateFull)(selectedShapesPrev, configuration, selectedShapeObjects, hoveredShapes, _gestures.mouseButton, _gestures.metaHeld, multiselectModifier, boxHighlightedShapes);
const selectionState = (0, _select.select)(_layout_functions.getSelectionState)(selectionStateFull);
const selectedShapes = (0, _select.select)(_layout_functions.getSelectedShapes)(selectionStateFull);
const selectedPrimaryShapeIds = (0, _select.select)(_layout_functions.getSelectedPrimaryShapeIds)(selectedShapes); // fixme unify with contentShape

const symmetricManipulation = _gestures.optionHeld; // as in comparable software applications, todo: make configurable

const resizeManipulator = (0, _select.select)(_layout_functions.getResizeManipulator)(configuration, symmetricManipulation);
const directManipulationTransformIntents = (0, _select.select)(_layout_functions.getTransformIntents)(configuration, directManipulationTransformGestures, selectedShapes, shapes, _gestures.cursorPosition, alterSnapGesture, resizeManipulator);
const alignAction = (0, _select.select)(_layout_functions.getAlignAction)(_gestures.actionEvent);
const distributeAction = (0, _select.select)(_layout_functions.getDistributeAction)(_gestures.actionEvent);
const alignDistributeTransformIntents = (0, _select.select)(_layout_functions.getAlignDistributeTransformIntents)(alignAction, distributeAction, shapes, selectedShapes);
const commandTransformIntents = alignDistributeTransformIntents; // will expand in the future, eg. nudge

const transformIntents = (0, _select.select)((directIntents, commandIntents) => directIntents.concat(commandIntents))(directManipulationTransformIntents, commandTransformIntents);
const transformedShapes = (0, _select.select)(_layout_functions.applyLocalTransforms)(shapes, transformIntents);
const draggedPrimaryShape = (0, _select.select)(_layout_functions.getDraggedPrimaryShape)(shapes, draggedShape);
const alignmentGuideAnnotations = (0, _select.select)(_layout_functions.getAlignmentGuideAnnotations)(configuration, transformedShapes, draggedPrimaryShape, draggedShape);
const shapesToHover = (0, _select.select)(_layout_functions.getShapesToHover)(dragBox, hoveredShapes, boxHighlightedShapes);
const hoverAnnotations = (0, _select.select)(_layout_functions.getHoverAnnotations)(configuration, shapesToHover, selectedPrimaryShapeIds, draggedShape);

// Once the interaction is over, ensure that the shape stays put where the constraint led it - distance is no longer relevant
// Note that this is what standard software (Adobe Illustrator, Google Slides, PowerPoint, Sketch etc.) do, but it's in
// stark contrast with the concept of StickyLines - whose central idea is that constraints remain applied until explicitly

const snappedShapes = (0, _select.select)(_layout_functions.getSnappedShapes)(configuration, transformedShapes, draggedShape, draggedPrimaryShape, alignmentGuideAnnotations, alterSnapGesture, symmetricManipulation);
const constrainedShapesWithPreexistingAnnotations = (0, _select.select)(_layout_functions.getConstrainedShapesWithPreexistingAnnotations)(snappedShapes, transformedShapes);
const rotationTooltipAnnotation = (0, _select.select)(_layout_functions.getRotationTooltipAnnotation)(configuration, draggedPrimaryShape, draggedShape, transformIntents, _gestures.cursorPosition);
const groupAction = (0, _select.select)(_layout_functions.getGroupAction)(_gestures.actionEvent, _gestures.mouseIsDown);
const groupingTuple = (0, _select.select)(_layout_functions.getGroupingTuple)(configuration, constrainedShapesWithPreexistingAnnotations, selectedShapes);
const grouping = (0, _select.select)(_layout_functions.getGrouping)(configuration, constrainedShapesWithPreexistingAnnotations, selectedShapes, groupAction, groupingTuple);
const groupedSelectedShapes = (0, _select.select)(_layout_functions.getGroupedSelectedShapes)(grouping);
const groupedSelectedShapeIds = (0, _select.select)(_layout_functions.getGroupedSelectedShapeIds)(groupedSelectedShapes);
const groupedSelectedPrimaryShapeIds = (0, _select.select)(_layout_functions.getGroupedSelectedPrimaryShapeIds)(groupedSelectedShapes);
const adHocChildrenAnnotations = (0, _select.select)(_layout_functions.getAdHocChildrenAnnotations)(configuration, grouping);
const resizeAnnotations = (0, _select.select)(_layout_functions.resizeAnnotationsFunction)(configuration, grouping);
const rotationAnnotations = (0, _select.select)(_layout_functions.getRotationAnnotations)(configuration, grouping);
const dragBoxAnnotation = (0, _select.select)(_layout_functions.getDragBoxAnnotation)(configuration, dragBox);
const annotatedShapes = (0, _select.select)(_layout_functions.getAnnotatedShapes)(grouping, alignmentGuideAnnotations, hoverAnnotations, rotationAnnotations, resizeAnnotations, rotationTooltipAnnotation, adHocChildrenAnnotations, dragBoxAnnotation);
const globalTransformShapes = (0, _select.select)(_layout_functions.cascadeProperties)(annotatedShapes);
const cursor = (0, _select.select)(_layout_functions.getCursor)(configuration, focusedShape, draggedPrimaryShape);

// this is the core scenegraph update invocation: upon new cursor position etc. emit the new scenegraph
// it's _the_ state representation (at a PoC level...) comprising of transient properties eg. draggedShape, and the
const nextScene = (0, _select.select)(_layout_functions.getNextScene)(configuration, hoveredShape, groupedSelectedShapeIds, groupedSelectedPrimaryShapeIds, globalTransformShapes, _gestures.gestureEnd, draggedShape, cursor, selectionState, mouseTransformState, _gestures.gestureState);
exports.nextScene = nextScene;
const updater = (0, _select.select)(_layout_functions.updaterFun)(nextScene, _common.primaryUpdate);
exports.updater = updater;