"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureCatalogueEntry = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const featureCatalogueEntry = {
  id: 'canvas',
  title: 'Canvas',
  subtitle: _i18n.i18n.translate('xpack.canvas.featureCatalogue.canvasSubtitle', {
    defaultMessage: 'Design pixel-perfect presentations.'
  }),
  description: _i18n.i18n.translate('xpack.canvas.appDescription', {
    defaultMessage: 'Showcase your data in a pixel-perfect way.'
  }),
  icon: 'canvasApp',
  path: '/app/canvas',
  showOnHomePage: false,
  category: 'data',
  solutionId: 'kibana',
  order: 300
};
exports.featureCatalogueEntry = featureCatalogueEntry;