"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticWorkpadPage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _element_wrapper = require("../../element_wrapper");
var _prop_types = require("../prop_types");
var _workpad = require("../../../lib/workpad");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StaticWorkpadPage extends _react.PureComponent {
  render() {
    const {
      pageId,
      pageStyle,
      className,
      animationStyle,
      elements,
      height,
      width
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: pageId,
      id: pageId,
      "data-test-subj": "canvasWorkpadPage",
      className: `canvasPage kbn-resetFocusState canvasStaticPage ${className}`,
      "data-shared-items-container": true,
      style: {
        ...pageStyle,
        ...animationStyle,
        height,
        width
      }
    }, elements.filter(node => !(0, _workpad.isGroupId)(node.id)).map(element => /*#__PURE__*/_react.default.createElement(_element_wrapper.ElementWrapper, {
      key: element.id,
      element: element
    })));
  }
}
exports.StaticWorkpadPage = StaticWorkpadPage;
(0, _defineProperty2.default)(StaticWorkpadPage, "propTypes", _prop_types.staticWorkpadPagePropTypes);