"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/visualizations-plugin/public");
var _ui_metric = require("../../../lib/ui_metric");
var _services = require("../../../services");
var _lib = require("../../../../common/lib");
var _embeddable_dataurl = require("../../../../common/lib/embeddable_dataurl");
var _editor_menu = require("./editor_menu.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditorMenu = ({
  addElement
}) => {
  const embeddablesService = (0, _services.useEmbeddablesService)();
  const {
    pathname,
    search,
    hash
  } = (0, _reactRouterDom.useLocation)();
  const stateTransferService = embeddablesService.getStateTransfer();
  const visualizationsService = (0, _services.useVisualizationsService)();
  const embeddableFactories = (0, _react.useMemo)(() => embeddablesService ? Array.from(embeddablesService.getEmbeddableFactories()) : [], [embeddablesService]);
  const [unwrappedEmbeddableFactories, setUnwrappedEmbeddableFactories] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    Promise.all(embeddableFactories.map(async factory => ({
      factory,
      isEditable: await factory.isEditable()
    }))).then(factories => {
      setUnwrappedEmbeddableFactories(factories);
    });
  }, [embeddableFactories]);
  const createNewVisType = (0, _react.useCallback)(visType => () => {
    let path = '';
    let appId = '';
    if (visType) {
      if (_ui_metric.trackCanvasUiMetric) {
        (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `${visType.name}:create`);
      }
      if ('aliasPath' in visType) {
        appId = visType.aliasApp;
        path = visType.aliasPath;
      } else {
        appId = 'visualize';
        path = `#/create?type=${encodeURIComponent(visType.name)}`;
      }
    } else {
      appId = 'visualize';
      path = '#/create?';
    }
    stateTransferService.navigateToEditor(appId, {
      path,
      state: {
        originatingApp: _lib.CANVAS_APP,
        originatingPath: `${pathname}${search}${hash}`
      }
    });
  }, [stateTransferService, pathname, search, hash]);
  const createNewEmbeddable = (0, _react.useCallback)(factory => async () => {
    if (_ui_metric.trackCanvasUiMetric) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.CLICK, factory.type);
    }
    let embeddableInput;
    if (factory.getExplicitInput) {
      embeddableInput = await factory.getExplicitInput();
    } else {
      const newEmbeddable = await factory.create({});
      embeddableInput = newEmbeddable === null || newEmbeddable === void 0 ? void 0 : newEmbeddable.getInput();
    }
    if (embeddableInput) {
      const config = (0, _embeddable_dataurl.encode)(embeddableInput);
      const expression = `embeddable config="${config}"
  type="${factory.type}"
| render`;
      addElement({
        expression
      });
    }
  }, [addElement]);
  const getVisTypesByGroup = group => visualizationsService.getByGroup(group).sort(({
    name: a
  }, {
    name: b
  }) => {
    if (a < b) {
      return -1;
    }
    if (a > b) {
      return 1;
    }
    return 0;
  }).filter(({
    hidden
  }) => !hidden);
  const visTypeAliases = visualizationsService.getAliases().sort(({
    promotion: a = false
  }, {
    promotion: b = false
  }) => a === b ? 0 : a ? -1 : 1);
  const factories = unwrappedEmbeddableFactories.filter(({
    isEditable,
    factory: {
      type,
      canCreateNew,
      isContainerType
    }
  }) => isEditable && !isContainerType && canCreateNew() && !['visualization', 'ml'].some(factoryType => {
    return type.includes(factoryType);
  })).map(({
    factory
  }) => factory);
  const promotedVisTypes = getVisTypesByGroup(_public.VisGroups.PROMOTED);
  return /*#__PURE__*/_react.default.createElement(_editor_menu.EditorMenu, {
    createNewVisType: createNewVisType,
    createNewEmbeddable: createNewEmbeddable,
    promotedVisTypes: promotedVisTypes,
    factories: factories,
    visTypeAliases: visTypeAliases
  });
};
exports.EditorMenu = EditorMenu;