"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadConfig = void 0;
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _workpad = require("../../state/actions/workpad");
var _workpad2 = require("../../state/selectors/workpad");
var _constants = require("../../../common/lib/constants");
var _workpad_config = require("./workpad_config.component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  const workpad = (0, _workpad2.getWorkpad)(state);
  return {
    name: (0, _lodash.get)(workpad, 'name'),
    size: {
      width: (0, _lodash.get)(workpad, 'width'),
      height: (0, _lodash.get)(workpad, 'height')
    },
    css: (0, _lodash.get)(workpad, 'css', _constants.DEFAULT_WORKPAD_CSS),
    variables: (0, _lodash.get)(workpad, 'variables', [])
  };
};
const mapDispatchToProps = {
  setSize: _workpad.sizeWorkpad,
  setName: _workpad.setName,
  setWorkpadCSS: _workpad.setWorkpadCSS,
  setWorkpadVariables: vars => (0, _workpad.updateWorkpadVariables)(vars)
};
const WorkpadConfig = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_workpad_config.WorkpadConfig);
exports.WorkpadConfig = WorkpadConfig;