"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VarValueField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getBooleanOptionsLegend: () => _i18n.i18n.translate('xpack.canvas.varConfigVarValueField.booleanOptionsLegend', {
    defaultMessage: 'Boolean value'
  }),
  getFalseOption: () => _i18n.i18n.translate('xpack.canvas.varConfigVarValueField.falseOption', {
    defaultMessage: 'False'
  }),
  getTrueOption: () => _i18n.i18n.translate('xpack.canvas.varConfigVarValueField.trueOption', {
    defaultMessage: 'True'
  })
};
const VarValueField = ({
  type,
  value,
  onChange
}) => {
  const idPrefix = (0, _eui.htmlIdGenerator)()();
  const options = [{
    id: `${idPrefix}-true`,
    label: strings.getTrueOption()
  }, {
    id: `${idPrefix}-false`,
    label: strings.getFalseOption()
  }];
  const onNumberChange = (0, _react.useCallback)(e => {
    const floatVal = parseFloat(e.target.value);
    const varValue = isNaN(floatVal) ? '' : floatVal;
    onChange(varValue);
  }, [onChange]);
  if (type === 'number') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      name: "value",
      value: value,
      onChange: onNumberChange
    });
  }
  if (type === 'boolean') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      name: "value",
      options: options,
      idSelected: `${idPrefix}-${value}`,
      onChange: id => {
        const val = id.replace(`${idPrefix}-`, '') === 'true';
        onChange(val);
      },
      buttonSize: "compressed",
      isFullWidth: true,
      legend: strings.getBooleanOptionsLegend()
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    name: "value",
    value: String(value),
    onChange: e => onChange(e.target.value)
  });
};
exports.VarValueField = VarValueField;