"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipIcon = exports.IconType = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint react/forbid-elements: 0 */
let IconType;
exports.IconType = IconType;
(function (IconType) {
  IconType["error"] = "error";
  IconType["warning"] = "warning";
  IconType["info"] = "info";
})(IconType || (exports.IconType = IconType = {}));
const TooltipIcon = ({
  icon = IconType.info,
  ...rest
}) => {
  const icons = {
    [IconType.error]: {
      type: 'error',
      color: 'danger'
    },
    [IconType.warning]: {
      type: 'warning',
      color: 'warning'
    },
    [IconType.info]: {
      type: 'iInCircle',
      color: 'default'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, (0, _extends2.default)({}, rest, {
    type: icons[icon].type,
    color: icons[icon].color
  }));
};
exports.TooltipIcon = TooltipIcon;
TooltipIcon.propTypes = {
  icon: _propTypes.default.string
};