"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarSectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SidebarSectionTitle = ({
  title,
  tip,
  children
}) => {
  const formattedTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    className: "canvasSidebar__panelTitleHeading"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title));
  const renderTitle = () => {
    if (tip) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "left",
        content: tip
      }, formattedTitle);
    }
    return formattedTitle;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasSidebar__panelTitle",
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderTitle(tip)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children));
};
exports.SidebarSectionTitle = SidebarSectionTitle;
SidebarSectionTitle.propTypes = {
  children: _propTypes.default.node,
  title: _propTypes.default.string,
  tip: _propTypes.default.string
};