"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sidebar_header = require("../../sidebar_header");
var _multi_element_settings = require("../multi_element_settings");
var _group_settings = require("../group_settings");
var _global_config = require("../global_config");
var _element_settings = require("../element_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getGroupedElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.groupedElementSidebarTitle', {
    defaultMessage: 'Grouped element',
    description: 'The title displayed when a grouped element is selected. "elements" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad. These elements can be grouped into a larger "grouped element" ' + 'that contains multiple individual elements.'
  }),
  getMultiElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.multiElementSidebarTitle', {
    defaultMessage: 'Multiple elements',
    description: 'The title displayed when multiple elements are selected. "elements" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad.'
  }),
  getSingleElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.singleElementSidebarTitle', {
    defaultMessage: 'Selected element',
    description: 'The title displayed when a single element are selected. "element" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad.'
  })
};
const MultiElementSidebar = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getMultiElementSidebarTitle()
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_multi_element_settings.MultiElementSettings, null));
const GroupedElementSidebar = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getGroupedElementSidebarTitle()
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_group_settings.GroupSettings, null));
const SingleElementSidebar = ({
  selectedElementId
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getSingleElementSidebarTitle(),
  showLayerControls: true
}), /*#__PURE__*/_react.default.createElement(_element_settings.ElementSettings, {
  selectedElementId: selectedElementId
}));
const SidebarContent = ({
  selectedToplevelNodes,
  selectedElementId
}) => {
  if (selectedToplevelNodes.length > 1) {
    return /*#__PURE__*/_react.default.createElement(MultiElementSidebar, null);
  }
  if (selectedToplevelNodes.length === 1 && selectedToplevelNodes[0].includes('group')) {
    return /*#__PURE__*/_react.default.createElement(GroupedElementSidebar, null);
  }
  if (selectedToplevelNodes.length === 1) {
    return /*#__PURE__*/_react.default.createElement(SingleElementSidebar, {
      selectedElementId: selectedElementId
    });
  }
  return /*#__PURE__*/_react.default.createElement(_global_config.GlobalConfig, null);
};
exports.SidebarContent = SidebarContent;