"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiElementSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getMultipleElementsActionsDescription: () => _i18n.i18n.translate('xpack.canvas.groupSettings.multipleElementsActionsDescription', {
    defaultMessage: 'Deselect these elements to edit their individual settings, press ({gKey}) to group them, or save this selection as a new ' + 'element to re-use it throughout your workpad.',
    values: {
      gKey: 'G'
    }
  }),
  getMultipleElementsDescription: () => _i18n.i18n.translate('xpack.canvas.groupSettings.multipleElementsDescription', {
    defaultMessage: 'Multiple elements are currently selected.'
  })
};
const MultiElementSettings = () => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasSidebar__panel canvasSidebar__panel--isEmpty"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, strings.getMultipleElementsDescription()), /*#__PURE__*/_react.default.createElement("p", null, strings.getMultipleElementsActionsDescription())));
exports.MultiElementSettings = MultiElementSettings;