"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _datasource = require("../../datasource");
var _function_form_list = require("../../function_form_list");
var _workpad_filters = require("../../workpad_filters/workpad_filters");
var _filter = require("../../../lib/filter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error unconverted component

// @ts-expect-error unconverted component

const strings = {
  getDataTabLabel: () => _i18n.i18n.translate('xpack.canvas.elementSettings.dataTabLabel', {
    defaultMessage: 'Data',
    description: 'This tab contains the settings for the data (i.e. Elasticsearch query) used as ' + 'the source for a Canvas element'
  }),
  getDisplayTabLabel: () => _i18n.i18n.translate('xpack.canvas.elementSettings.displayTabLabel', {
    defaultMessage: 'Display',
    description: 'This tab contains the settings for how data is displayed in a Canvas element'
  }),
  getFiltersTabLabel: () => _i18n.i18n.translate('xpack.canvas.elementSettings.filtersTabLabel', {
    defaultMessage: 'Filters',
    description: 'This tab contains information about filters related to a Canvas element'
  })
};
const ElementSettings = ({
  element
}) => {
  const tabs = (0, _react.useMemo)(() => {
    const filtersTab = (0, _filter.isExpressionWithFilters)(element.expression) && {
      id: 'filters',
      name: strings.getFiltersTabLabel(),
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar__pop"
      }, /*#__PURE__*/_react.default.createElement(_workpad_filters.WorkpadFilters, {
        element: element
      })),
      'data-test-subj': 'canvasSidebarFiltersTab'
    };
    return [{
      id: 'edit',
      name: strings.getDisplayTabLabel(),
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar__pop"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar--args"
      }, /*#__PURE__*/_react.default.createElement(_function_form_list.FunctionFormList, {
        element: element
      }))),
      'data-test-subj': 'canvasSidebarDisplayTab'
    }, {
      id: 'data',
      name: strings.getDataTabLabel(),
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar__pop"
      }, /*#__PURE__*/_react.default.createElement(_datasource.Datasource, null)),
      'data-test-subj': 'canvasSidebarDataTab'
    }, ...(filtersTab ? [filtersTab] : [])];
  }, [element]);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(tabs[0].id);
  const onSelectedTabChanged = id => {
    setSelectedTab(id);
  };
  const tabsHeaders = tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTab,
    "data-test-subj": tab['data-test-subj']
  }, tab.name));
  const tabsContent = (0, _react.useMemo)(() => tabs.map(({
    id,
    content
  }) => id === selectedTab ? content :
  /*#__PURE__*/
  // tabs must be hidden, but mounted, because `Display` tab, for example,
  // contains args, which should react on input changes and change the expression,
  // according to the logic they encapsulate.
  // Good example: columns have changed, the args of expression `math` should be changed, containing the new columns.
  _react.default.createElement("div", {
    style: {
      display: 'none'
    }
  }, content)), [selectedTab, tabs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, tabsHeaders), tabsContent);
};
exports.ElementSettings = ElementSettings;
ElementSettings.propTypes = {
  element: _propTypes.default.object
};