"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderWithFn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _services = require("../../services");
var _render_to_dom = require("../render_to_dom");
var _i18n = require("../../../i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  RenderWithFn: strings
} = _i18n.ErrorStrings;
const style = {
  height: '100%',
  width: '100%'
};
const RenderWithFn = ({
  name: functionName,
  renderFn,
  reuseNode = false,
  handlers: incomingHandlers,
  config,
  width,
  height
}) => {
  const {
    error: onError
  } = (0, _services.useNotifyService)();
  const [domNode, setDomNode] = (0, _react.useState)(null);

  // Tells us if the component is attempting to re-render into a previously-populated render target.
  const firstRender = (0, _react.useRef)(true);
  // A reference to the node appended to the provided DOM node which is created and optionally replaced.
  const renderTarget = (0, _react.useRef)(null);
  // A reference to the handlers, as the renderFn may mutate them, (via onXYZ functions)
  const handlers = (0, _react.useRef)(incomingHandlers);

  // Reset the render target, the node appended to the DOM node provided by RenderToDOM.
  const resetRenderTarget = (0, _react.useCallback)(() => {
    if (!domNode) {
      return;
    }
    if (!firstRender.current) {
      handlers.current.destroy();
    }
    while (domNode.firstChild) {
      domNode.removeChild(domNode.firstChild);
    }
    const div = document.createElement('div');
    div.style.width = '100%';
    div.style.height = '100%';
    domNode.appendChild(div);
    renderTarget.current = div;
    firstRender.current = true;
  }, [domNode]);
  (0, _react.useEffect)(() => handlers.current.resize({
    height,
    width
  }), [height, width]);
  (0, _react.useEffect)(() => () => {
    handlers.current.destroy();
  }, []);
  const render = (0, _react.useCallback)(async () => {
    if (!(0, _lodash.isEqual)(handlers.current, incomingHandlers)) {
      handlers.current = incomingHandlers;
    }
    await renderFn(renderTarget.current, config, handlers.current);
  }, [renderTarget, config, renderFn, incomingHandlers]);
  (0, _react.useEffect)(() => {
    if (!domNode) {
      return;
    }
    if (!reuseNode || !renderTarget.current) {
      resetRenderTarget();
    }
    render().then(() => {
      firstRender.current = false;
    }).catch(err => {
      onError(err, {
        title: strings.getRenderErrorMessage(functionName)
      });
    });
  }, [domNode, functionName, onError, render, resetRenderTarget, reuseNode]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasWorkpad--element_render canvasRenderEl",
    style: style
  }, /*#__PURE__*/_react.default.createElement(_render_to_dom.RenderToDom, {
    style: style,
    render: node => {
      setDomNode(node);
    }
  }));
};
exports.RenderWithFn = RenderWithFn;