"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemGrid = void 0;
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PER_ROW_DEFAULT = 6;
const ItemGrid = function ItemGridFunc({
  items = [],
  itemsPerRow = PER_ROW_DEFAULT,
  children
}) {
  const reducedRows = items.reduce((rows, item) => {
    let end = (0, _lodash.last)(rows);
    if (end && end.length >= itemsPerRow) {
      rows.push([]);
    }
    end = (0, _lodash.last)(rows);
    if (end) {
      end.push(children(item));
    }
    return rows;
  }, [[]]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, reducedRows.map((row, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: `item-grid-row-${i}`,
    className: "item-grid-row"
  }, row)));
};
exports.ItemGrid = ItemGrid;
ItemGrid.propTypes = {
  items: _propTypes.default.array,
  itemsPerRow: _propTypes.default.number,
  children: _propTypes.default.func.isRequired
};