"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _breadcrumbs = require("../../lib/breadcrumbs");
var _workpad = require("../../state/actions/workpad");
var _home_app = require("./home_app.component");
var _services = require("../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HomeApp = () => {
  const {
    setBreadcrumbs
  } = (0, _services.usePlatformService)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const onLoad = () => dispatch((0, _workpad.resetWorkpad)());
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumbs.getBaseBreadcrumb)(history)]);
  }, [setBreadcrumbs, history]);
  return /*#__PURE__*/_react.default.createElement(_home_app.HomeApp, {
    onLoad: onLoad
  });
};
exports.HomeApp = HomeApp;