"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadImport = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _app = require("../../../state/selectors/app");
var _hooks = require("../hooks");
var _workpad_import = require("./workpad_import.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadImport = props => {
  const importWorkpad = (0, _hooks.useImportWorkpad)();
  const [uniqueKey, setUniqueKey] = (0, _react.useState)(Date.now());
  const {
    canUserWrite
  } = (0, _reactRedux.useSelector)(state => ({
    canUserWrite: (0, _app.canUserWrite)(state)
  }));
  const onImportWorkpad = files => {
    if (files) {
      importWorkpad(files[0]);
    }
    setUniqueKey(Date.now());
  };
  return /*#__PURE__*/_react.default.createElement(_workpad_import.WorkpadImport, (0, _extends2.default)({}, props, {
    uniqueKey,
    onImportWorkpad,
    canUserWrite
  }));
};
exports.WorkpadImport = WorkpadImport;