"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldsSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _services = require("../../services");
var _es_fields_select = require("./es_fields_select.component");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESFieldsSelect = props => {
  const {
    index,
    selected,
    onChange
  } = props;
  const [fields, setFields] = (0, _react.useState)([]);
  const prevIndex = (0, _usePrevious.default)(index);
  const mounted = (0, _react.useRef)(true);
  const {
    getFields
  } = (0, _services.useDataViewsService)();
  (0, _react.useEffect)(() => {
    if (prevIndex !== index) {
      getFields(index).then(newFields => {
        if (!mounted.current) {
          return;
        }
        setFields(newFields || []);
        const filteredSelected = selected.filter(option => (newFields || []).includes(option));
        if (!(0, _lodash.isEqual)(filteredSelected, selected)) {
          onChange(filteredSelected);
        }
      });
    }
  }, [fields, index, onChange, prevIndex, selected, getFields]);
  (0, _react.useEffect)(() => () => {
    mounted.current = false;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_es_fields_select.ESFieldsSelect, (0, _extends2.default)({}, props, {
    fields: fields
  }));
};
exports.ESFieldsSelect = ESFieldsSelect;