"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _workpad = require("../../state/selectors/workpad");
var _services = require("../../services");
var _element_content = require("./element_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElementContent = props => {
  const expressionsService = (0, _services.useExpressionsService)();
  const selectedPageId = (0, _reactRedux.useSelector)(_workpad.getSelectedPage);
  const backgroundColor = (0, _reactRedux.useSelector)(state => {
    var _getPageById;
    return (_getPageById = (0, _workpad.getPageById)(state, selectedPageId)) === null || _getPageById === void 0 ? void 0 : _getPageById.style.background;
  }) || '';
  const {
    renderable
  } = props;
  const renderFunction = renderable ? expressionsService.getRenderer(renderable.as) : null;
  return /*#__PURE__*/_react.default.createElement(_element_content.ElementContent, (0, _extends2.default)({}, props, {
    renderFunction,
    backgroundColor
  }));
};
exports.ElementContent = ElementContent;