"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getFailedLabel: () => _i18n.i18n.translate('xpack.canvas.elementConfig.failedLabel', {
    defaultMessage: 'Failed',
    description: 'The label for the total number of elements in a workpad that have thrown an error or failed to load'
  }),
  getLoadedLabel: () => _i18n.i18n.translate('xpack.canvas.elementConfig.loadedLabel', {
    defaultMessage: 'Loaded',
    description: 'The label for the number of elements in a workpad that have loaded'
  }),
  getProgressLabel: () => _i18n.i18n.translate('xpack.canvas.elementConfig.progressLabel', {
    defaultMessage: 'Progress',
    description: 'The label for the percentage of elements that have finished loading'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.elementConfig.title', {
    defaultMessage: 'Element status',
    description: '"Elements" refers to the individual text, images, or visualizations that you can add to a Canvas workpad'
  }),
  getTotalLabel: () => _i18n.i18n.translate('xpack.canvas.elementConfig.totalLabel', {
    defaultMessage: 'Total',
    description: 'The label for the total number of elements in a workpad'
  })
};
const ElementConfig = ({
  elementStats
}) => {
  if (!elementStats) {
    return null;
  }
  const {
    total,
    ready,
    error
  } = elementStats;
  const progress = total > 0 ? Math.round((ready + error) / total * 100) : 100;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__expandable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "canvas-element-stats",
    buttonContent: strings.getTitle(),
    initialIsOpen: false,
    className: "canvasSidebar__accordion"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: total,
    description: strings.getTotalLabel(),
    titleSize: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: ready,
    description: strings.getLoadedLabel(),
    titleSize: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: error,
    description: strings.getFailedLabel(),
    titleSize: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: progress + '%',
    description: strings.getProgressLabel(),
    titleSize: "xs"
  }))))));
};
exports.ElementConfig = ElementConfig;
ElementConfig.propTypes = {
  elementStats: _propTypes.default.object
};