"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPicker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getAssetAltText: () => _i18n.i18n.translate('xpack.canvas.assetpicker.assetAltText', {
    defaultMessage: 'Asset thumbnail'
  })
};
class AssetPicker extends _react.PureComponent {
  componentDidMount() {
    const selectedAsset = document.getElementById('canvasAssetPicker__selectedAsset');
    if (selectedAsset) {
      selectedAsset.scrollIntoView();
    }
  }
  render() {
    const {
      assets,
      selected,
      onChange
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      id: "canvasAssetPicker",
      className: "canvasAssetPicker",
      gutterSize: "s",
      columns: 4
    }, assets.map(asset => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: asset.id,
      id: asset.id === selected ? 'canvasAssetPicker__selectedAsset' : '',
      className: "canvasCheckered"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: `canvasAssetPicker__link`,
      disabled: asset.id === selected,
      onClick: () => onChange(asset)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: asset.value,
      alt: strings.getAssetAltText()
    }), asset.id === selected && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "canvasAssetPicker__selected",
      type: "checkInCircleFilled"
    })))));
  }
}
exports.AssetPicker = AssetPicker;
(0, _defineProperty2.default)(AssetPicker, "propTypes", {
  assets: _propTypes.default.array.isRequired,
  selected: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired
});