"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEncodedContent = getEncodedContent;
exports.getSourceMapId = getSourceMapId;
var _zlib = require("zlib");
var _crypto = require("crypto");
var _util = require("util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deflateAsync = (0, _util.promisify)(_zlib.deflate);
function asSha256Encoded(content) {
  return (0, _crypto.createHash)('sha256').update(content).digest('hex');
}
async function getEncodedContent(sourceMapContent) {
  const contentBuffer = Buffer.from(JSON.stringify(sourceMapContent));
  const contentZipped = await deflateAsync(contentBuffer);
  const contentEncoded = contentZipped.toString('base64');
  const contentHash = asSha256Encoded(contentZipped);
  return {
    contentEncoded,
    contentHash
  };
}
function getSourceMapId({
  serviceName,
  serviceVersion,
  bundleFilepath
}) {
  return [serviceName, serviceVersion, bundleFilepath].join('-');
}