"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApmSourceMapIndexTemplate = createApmSourceMapIndexTemplate;
var _server = require("@kbn/observability-plugin/server");
var _get_apm_indices = require("../settings/apm_indices/get_apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexTemplate = {
  name: 'apm-source-map',
  body: {
    version: 1,
    index_patterns: [_get_apm_indices.APM_SOURCE_MAP_INDEX],
    template: {
      settings: {
        index: {
          number_of_shards: 1,
          auto_expand_replicas: '0-2',
          hidden: true
        }
      },
      mappings: {
        dynamic: 'strict',
        properties: {
          fleet_id: {
            type: 'keyword'
          },
          created: {
            type: 'date'
          },
          content: {
            type: 'binary'
          },
          content_sha256: {
            type: 'keyword'
          },
          'file.path': {
            type: 'keyword'
          },
          'service.name': {
            type: 'keyword'
          },
          'service.version': {
            type: 'keyword'
          }
        }
      }
    }
  }
};
async function createApmSourceMapIndexTemplate({
  client,
  logger
}) {
  // create index template
  await (0, _server.createOrUpdateIndexTemplate)({
    indexTemplate,
    client,
    logger
  });

  // create index if it doesn't exist
  const indexExists = await client.indices.exists({
    index: _get_apm_indices.APM_SOURCE_MAP_INDEX
  });
  if (!indexExists) {
    logger.debug(`Create index: "${_get_apm_indices.APM_SOURCE_MAP_INDEX}"`);
    await client.indices.create({
      index: _get_apm_indices.APM_SOURCE_MAP_INDEX
    });
  }
}