"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApmCustomLinkIndex = void 0;
var _server = require("@kbn/observability-plugin/server");
var _get_apm_indices = require("../apm_indices/get_apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createApmCustomLinkIndex = async ({
  client,
  logger
}) => {
  return (0, _server.createOrUpdateIndex)({
    index: _get_apm_indices.APM_CUSTOM_LINK_INDEX,
    client,
    logger,
    mappings
  });
};
exports.createApmCustomLinkIndex = createApmCustomLinkIndex;
const mappings = {
  dynamic: 'strict',
  properties: {
    '@timestamp': {
      type: 'date'
    },
    label: {
      type: 'text',
      fields: {
        // Adding keyword type to be able to sort by label alphabetically
        keyword: {
          type: 'keyword'
        }
      }
      // FIXME: PropertyBase type is missing .fields
    },

    url: {
      type: 'keyword'
    },
    service: {
      properties: {
        name: {
          type: 'keyword'
        },
        environment: {
          type: 'keyword'
        }
      }
    },
    transaction: {
      properties: {
        name: {
          type: 'keyword'
        },
        type: {
          type: 'keyword'
        }
      }
    }
  }
};